%% load the data by entering in the folder with the morphomaps of interest

% for trajectory centered
outfolders=dir(pwd);
i=1;
for z=1:size(outfolders)
S=strfind(outfolders(z).name,'cellTrajcenter.fig');
  if isempty(S)<1
        name{i}=(strcat(pwd,'\',outfolders(z).name));
        i=i+1;
  end
end
Nc = length(name);

%% average morpho map traj centered
for i=1:Nc
fig = openfig(name{i});
fig = gcf;
M = getimage(fig);
meanM(:,i) = mean(M,2);
close(fig)
end

%% plot
figure;
hold all
for i=1:Nc
    plot(meanM(:,i))
end

%% plot average of the average
figure;
plot(mean(meanM,2))

%% final fig
figure;
hold on
%plot(meanM,'color',[1 0 0 0.2])
plot(mean(meanM,2),'r','linewidth',2)
stdM = std(meanM,0,2);
plot(mean(meanM,2)+stdM,'--r','linewidth',0.5)
plot(mean(meanM,2)-stdM,'--r','linewidth',0.5)

%% save data
save('meanM.mat','meanM')
save('stdM.mat','stdM')




